﻿using System;
using System.Windows.Forms;
using RDR2;
using RDR2.UI;
using RDR2.Native;
using RDR2.Math;

namespace HCL_Superpower_05
{
    public class Main : Script
    {
/// /////////////////////////////////////////////
        Keys BlinkKey = Keys.X;  // The blink key. can set to any key beside Shift, Alt or Control.
/// =============The following part let you set the blink distance. It only matters when you want to teleport to mid air.======================
        Keys IncreaseDistanceKey = Keys.F11;  // Hold this key while holding the blink key to increase blink distance. can set to any key beside Shift, Alt or Control.
        Keys DecreaseDistanceKey = Keys.F12;  // Hold this key while holding the blink key to decrease blink distance. can set to any key beside Shift, Alt or Control.
        float DefaultLength = 50.0f; // The blink distance will reset to this value every time you hold the blink key. 
        float MaxLength = 50.0f;  // The maximum length of a blink.
        float MinLength = 2.5f;  // The minimum Length of a blink.
/// /////////////////////////////////////////////
        Player player = Game.Player;
        Ped playerPed = Game.Player.Character;
        bool KeyPressed = false;
        float TPLength = 50.0f;
        Entity RayEntity = null;

        public Main()
        {
            KeyDown += OnKeyDown;
            KeyUp += OnKeyUp;
            Tick += OnTick;
            Interval = 1;
        }

        private void OnTick(object sender, EventArgs e)
        {
            if (KeyPressed)
            {
                    Function.Call(Hash.DRAW_RECT, 0.5, 0.5, 0.00375, 0.0075, 235, 180, 255, 255); 
                    Function.Call(Hash.DRAW_RECT, 0.5, 0.5, 0.0025, 0.005, 40, 0, 60, 255); 
                    Function.Call(Hash.DRAW_RECT, 0.95, 0.65, 0.00375, 0.15, 235, 180, 255, 255); 
                    Function.Call(Hash.DRAW_RECT, 0.95, 0.65, 0.0025, ((0.15 / MaxLength) * TPLength), 40, 0, 60, 255); 
                    if (Game.IsKeyPressed(IncreaseDistanceKey) && !Game.IsKeyPressed(DecreaseDistanceKey) && TPLength < MaxLength)
                    {
                              TPLength = TPLength + 0.5f;
                    }
                    if (!Game.IsKeyPressed(IncreaseDistanceKey) && Game.IsKeyPressed(DecreaseDistanceKey) && TPLength > MinLength)
                    {
                              TPLength = TPLength - 0.5f;
                    }
            }
        } 

        private void OnKeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == BlinkKey && !e.Shift && !player.Character.IsInVehicle() && !Function.Call<bool>(Hash.IS_PED_ON_MOUNT, playerPed))
            {
                     KeyPressed = true;
            }
        }

        private void OnKeyUp(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == BlinkKey && !e.Shift && !player.Character.IsInVehicle() && !Function.Call<bool>(Hash.IS_PED_ON_MOUNT, playerPed))
            {
                     if (RayEntity == null)
                     {
                              Model PlayerModel = new Model(Function.Call<int>(Hash.GET_ENTITY_MODEL, playerPed));
	              Function.Call(Hash.REQUEST_MODEL, PlayerModel);
                              while (!Function.Call<bool>(Hash.HAS_MODEL_LOADED, PlayerModel))
                              {
                                       Wait(1);
                              }
	              RayEntity = Function.Call<Ped>(Hash.CREATE_PED, PlayerModel, 0, 0, 0, 1.0, false, false);
                              Function.Call(Hash.SET_ENTITY_INVINCIBLE, RayEntity, true);
                     }
                     Vector3 RaySpace = new Vector3(RotToDir(NC_Get_Cam_Rotation()).X * 100.0f, RotToDir(NC_Get_Cam_Rotation()).Y * 100.0f, RotToDir(NC_Get_Cam_Rotation()).Z * 100.0f);
                     Vector3 TargetPosition = NC_Get_Cam_Position() + RaySpace;
                     Function.Call(Hash.SET_ENTITY_VISIBLE, RayEntity, false);
                     Function.Call(Hash.SET_ENTITY_HAS_GRAVITY, RayEntity, false);
                     Function.Call(Hash.SET_ENTITY_ROTATION, RayEntity, 0, 0, ((NC_Get_Cam_Rotation()).Z), 2, true); 
                     Function.Call(Hash.SET_ENTITY_COORDS, RayEntity, TargetPosition.X, TargetPosition.Y, (TargetPosition.Z), true, false, false, false);
                     Wait(10);
                     RaycastResult Raycast = World.Raycast(NC_Get_Cam_Position(), RayEntity.Position, IntersectOptions.Everything, playerPed);
                     Wait(10);
                     if (Raycast.DitHit && Raycast.HitPosition != new Vector3(0, 0, 0) && World.GetDistance(playerPed.Position, Raycast.HitPosition) < TPLength) 
                     {
                               Vector3 castcoord = Raycast.HitPosition + new Vector3(0, 0, 0.00005f) + new Vector3(RotToDir(NC_Get_Cam_Rotation()).X * (-0.00001f), RotToDir(NC_Get_Cam_Rotation()).Y * (-0.00001f), RotToDir(NC_Get_Cam_Rotation()).Z * (-0.00001f));
                               Function.Call(Hash.SET_ENTITY_COORDS, RayEntity, castcoord.X, castcoord.Y, (castcoord.Z - 10.0f), true, false, false, false);
                               Wait(10);
                               RaycastResult RayTW1 = World.Raycast(castcoord, RayEntity.Position, IntersectOptions.Everything, playerPed);
                               Wait(10);
                               if (RayTW1.DitHit && World.GetDistance(Raycast.HitPosition, RayTW1.HitPosition) < 1.85f)
                               {
                                        Vector3 TW1coord = RayTW1.HitPosition;
                                        Function.Call(Hash.SET_ENTITY_COORDS, playerPed, RayTW1.HitPosition.X, RayTW1.HitPosition.Y, RayTW1.HitPosition.Z, true, false, false, false);
                               } 
                               else
                               {
                                        Function.Call(Hash.SET_ENTITY_COORDS, playerPed, Raycast.HitPosition.X, Raycast.HitPosition.Y, (Raycast.HitPosition.Z - 1.85f), true, false, false, false);
                               }
                     }
                     else
                     {
                               Vector3 AAAA = new Vector3(RotToDir(NC_Get_Cam_Rotation()).X * TPLength, RotToDir(NC_Get_Cam_Rotation()).Y * TPLength, RotToDir(NC_Get_Cam_Rotation()).Z * TPLength);
                               Vector3 currentPosition = playerPed.Position;   
                               Vector3 castcoord = currentPosition + AAAA;
                               Function.Call(Hash.SET_ENTITY_COORDS, RayEntity, castcoord.X, castcoord.Y, (castcoord.Z - 10.0f), true, false, false, false);
                               Wait(10);
                               RaycastResult RayTW1 = World.Raycast(castcoord, RayEntity.Position, IntersectOptions.Everything, playerPed);
                               Wait(10);
                               if (RayTW1.DitHit && World.GetDistance(castcoord, RayTW1.HitPosition) < 1.85f)
                               {
                                       Vector3 TW1coord = RayTW1.HitPosition;
                                       Function.Call(Hash.SET_ENTITY_COORDS, playerPed, RayTW1.HitPosition.X, RayTW1.HitPosition.Y,  RayTW1.HitPosition.Z, true, false, false, false);
                               } 
                               else
                               {
                                       Function.Call(Hash.SET_ENTITY_COORDS, playerPed, (currentPosition.X + AAAA.X), (currentPosition.Y + AAAA.Y), (currentPosition.Z + AAAA.Z - 1.85f), true, false, false, false);
                               }    
                     }
                     Wait(10);
                     Function.Call(Hash.SET_ENTITY_COORDS, RayEntity, 0, 0, 0, true, false, false, false);
                     TPLength = DefaultLength;
            }
            if (e.KeyCode == BlinkKey)
            {
                     KeyPressed = false;
            }
        }

        public Vector3 RotToDir(Vector3 Rot)
        {
            try
            {
                float z = Rot.Z;
                float retz = z * 0.0174532924F;
                float x = Rot.X;
                float retx = x * 0.0174532924F;
                float absx = (float)System.Math.Abs(System.Math.Cos(retx));
                return new Vector3((float)-System.Math.Sin(retz) * absx, (float)System.Math.Cos(retz) * absx, (float)System.Math.Sin(retx));
            }
            catch
            {
                return new Vector3(0, 0, 0);
            }
        }

        public Vector3 NC_Get_Cam_Position()
        {
            try
            {
                return Function.Call<Vector3>(Hash.GET_GAMEPLAY_CAM_COORD);
            }
            catch
            {

            }
            return new Vector3(0, 0, 0);
        }

        public Vector3 NC_Get_Cam_Rotation()
        {
            try
            {
                return Function.Call<Vector3>(Hash.GET_GAMEPLAY_CAM_ROT, 0);
            }
            catch
            {

            }
            return new Vector3(0, 0, 0);
        } 
    }
}
